;(() => {
  function loadPartial(elementId, partialPath) {
    const container = document.getElementById(elementId)
    if (!container) return

    fetch(partialPath)
      .then((response) => {
        if (!response.ok) throw new Error("Failed to load partial: " + partialPath)
        return response.text()
      })
      .then((html) => {
        container.innerHTML = html

        if (elementId === "header-container") {
          initMobileMenu(container)
          document.dispatchEvent(new CustomEvent("partials:headerLoaded"))
        }
      })
      .catch(() => {})
  }

  function initMobileMenu(root) {
    const toggleBtn = root.querySelector(".mobile-menu-toggle")
    const overlay = document.querySelector(".mobile-menu-overlay")
    const closeBtn = overlay?.querySelector(".mobile-menu-close")
    const body = document.body

    if (!toggleBtn || !overlay) return

    function setOpen(isOpen) {
      overlay.classList.toggle("active", isOpen)
      overlay.classList.toggle("is-open", isOpen)
      overlay.hidden = !isOpen

      body.classList.toggle("menu-open", isOpen)
      body.classList.toggle("no-scroll", isOpen)

      toggleBtn.setAttribute("aria-expanded", String(isOpen))
    }

    setOpen(false)

    toggleBtn.addEventListener("click", (e) => {
      e.preventDefault()
      const isOpen = !overlay.hidden || overlay.classList.contains("active") || overlay.classList.contains("is-open")
      setOpen(!isOpen)
    })

    if (closeBtn) {
      closeBtn.addEventListener("click", (e) => {
        e.preventDefault()
        setOpen(false)
      })
    }

    overlay.addEventListener("click", (e) => {
      if (e.target === overlay) setOpen(false)
    })

    document.addEventListener("keydown", (e) => {
      if (e.key === "Escape") {
        const isOpen = !overlay.hidden || overlay.classList.contains("active") || overlay.classList.contains("is-open")
        if (isOpen) setOpen(false)
      }
    })
  }

  function loadAllPartials() {
    loadPartial("header-container", "/partials/header.html")
    loadPartial("footer-container", "/partials/footer.html")
  }

  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", loadAllPartials)
  } else {
    loadAllPartials()
  }
})()
