;(() => {
  function initDropdown() {
    const dropdown = document.querySelector(".nav-dropdown")
    const dropdownTrigger = document.querySelector(".nav-dropdown-trigger")
    const dropdownMenu = document.querySelector(".nav-dropdown-menu")

    if (!dropdown || !dropdownTrigger || !dropdownMenu) return

    dropdownTrigger.addEventListener("click", (e) => {
      e.stopPropagation()
      const isActive = dropdown.classList.contains("active")
      dropdown.classList.toggle("active")
      dropdownTrigger.setAttribute("aria-expanded", String(!isActive))
    })

    document.addEventListener("click", (e) => {
      if (!dropdown.contains(e.target)) {
        dropdown.classList.remove("active")
        dropdownTrigger.setAttribute("aria-expanded", "false")
      }
    })

    document.addEventListener("keydown", (e) => {
      if (e.key === "Escape" && dropdown.classList.contains("active")) {
        dropdown.classList.remove("active")
        dropdownTrigger.setAttribute("aria-expanded", "false")
        dropdownTrigger.focus()
      }
    })

    const dropdownItems = dropdownMenu.querySelectorAll(".dropdown-item")
    dropdownItems.forEach((item) => {
      item.addEventListener("click", () => {
        dropdown.classList.remove("active")
        dropdownTrigger.setAttribute("aria-expanded", "false")
      })
    })
  }

  function initSmoothAnchors() {
    document.addEventListener("click", (e) => {
      const a = e.target.closest("a")
      if (!a) return
      const href = a.getAttribute("href")
      if (!href || !href.startsWith("#")) return

      const targetId = href.substring(1)
      const targetElement = document.getElementById(targetId)
      if (!targetElement) return

      e.preventDefault()
      targetElement.scrollIntoView({ behavior: "smooth", block: "start" })
    })
  }

  function initIntersectionAnimations() {
    if (!("IntersectionObserver" in window)) return

    function handleIntersection(entries, observer) {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          entry.target.classList.add("in-view")
          observer.unobserve(entry.target)
        }
      })
    }

    const observer = new IntersectionObserver(handleIntersection, {
      threshold: 0.1,
      rootMargin: "0px 0px -50px 0px",
    })

    setTimeout(() => {
      const casinoCards = document.querySelectorAll(".casino-card")
      casinoCards.forEach((card) => observer.observe(card))
    }, 100)
  }

  function initAll() {
    initDropdown()
    initSmoothAnchors()
    initIntersectionAnimations()
  }

  initAll()
  document.addEventListener("partials:headerLoaded", initDropdown)
})()
